<?php
/**
 * [PROWEBBER.ru - 2019]
 */

defined('PHPFOX') or exit('NO DICE!');

/**
 *
 *
 * @copyright        [PHPFOX_COPYRIGHT]
 * @author        Raymond_Benc
 * @package        Phpfox_Service
 * @version        $Id: process.class.php 6496 2013-08-23 11:34:09Z Fern $
 */
class Link_Service_Process extends Phpfox_Service
{
    private $_iLinkId = 0;

    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->_sTable = Phpfox::getT('link');
    }

    public function mailToTagged($linkId, $userId)
    {
        $this->_notifyTaggedUser($linkId, $userId);
    }

    public function add($aVals, $bIsCustom = false, $aCallback = null)
    {
        if (!defined('PHPFOX_FORCE_IFRAME')) {
            define('PHPFOX_FORCE_IFRAME', true);
        }

        $hasPrivacy = [
            'privacy_comment' => true,
            'privacy' => true
        ];

        if (!isset($aVals['privacy_comment'])) {
            $aVals['privacy_comment'] = 0;
            $hasPrivacy['privacy_comment'] = false;
        }

        if (!isset($aVals['privacy'])) {
            $aVals['privacy'] = 0;
            $hasPrivacy['privacy'] = false;
        }

        if ((trim($aVals['link']['url']) == trim($aVals['status_info'])) && (!empty($aVals['link']['title']) || !empty($aVals['link']['description']))) {
            $aVals['status_info'] = null;
        }

        $isUpdate = !!($aVals['feed_id']);
        $feed = $isUpdate ? Phpfox::getService('feed')->getFeed($aVals['feed_id'], !empty($aCallback['table_prefix']) ? ($aCallback['table_prefix']) : '') : [];
        if($isUpdate && empty($feed)) {
            return false;
        }
        $isNormalStatus = in_array($feed['type_id'], ['user_status', 'feed_comment']);

        $needInsert = !empty($feed['type_id']) &&  ($isNormalStatus || (!empty($aCallback['module']) && $feed['type_id'] == ($aCallback['module']. '_' .'comment'))) ? true : false;
        $aInsert = [
            'is_custom' => ($bIsCustom ? '1' : '0'),
            'link' => $this->preParse()->clean($aVals['link']['url'], 255),
            'image' => ((isset($aVals['link']['image_hide']) && $aVals['link']['image_hide'] == '1') || !isset($aVals['link']['image']) ? null : $this->preParse()->clean($aVals['link']['image'], 1023)),
            'title' => (isset($aVals['link']['title']) ? $this->preParse()->clean($aVals['link']['title'], 255) : ''),
            'description' => isset($aVals['link']['description']) ? $this->preParse()->clean($aVals['link']['description'], 200) : '',
            'status_info' => (empty($aVals['status_info']) ? null : $this->preParse()->prepare($aVals['status_info'])),
            'privacy' => (int)$aVals['privacy'],
            'has_embed' => (empty($aVals['link']['embed_code']) ? '0' : '1')
        ];
        if(!$isUpdate || $needInsert) {
            $aInsert = array_merge($aInsert, [
                'user_id' => Phpfox::getUserId(),
                'module_id' => ($aCallback === null ? null : $aCallback['module']),
                'item_id' => ($aCallback === null ? 0 : $aCallback['item_id']),
                'parent_user_id' => (isset($aVals['parent_user_id']) ? (int)$aVals['parent_user_id'] : 0),
                'privacy_comment' => (int)$aVals['privacy_comment'],
                'time_stamp' => PHPFOX_TIME,
            ]);
        }

        if (isset($aVals['location']) && isset($aVals['location']['latlng']) && !empty($aVals['location']['latlng'])) {
            $aMatch = explode(',', $aVals['location']['latlng']);
            $aMatch['latitude'] = floatval($aMatch[0]);
            $aMatch['longitude'] = floatval($aMatch[1]);
            $aInsert['location_latlng'] = json_encode(array('latitude' => $aMatch['latitude'], 'longitude' => $aMatch['longitude']));
        }

        if (isset($aInsert['location_latlng']) && !empty($aInsert['location_latlng']) && isset($aVals['location']) && isset($aVals['location']['name']) && !empty($aVals['location']['name'])) {
            $aInsert['location_name'] = Phpfox::getLib('parse.input')->clean($aVals['location']['name']);
        }

        if(!$isUpdate || $needInsert) {
            $iId = $this->database()->insert($this->_sTable, $aInsert);
            if($isNormalStatus || (!empty($aCallback['module']) && $feed['type_id'] == ($aCallback['module'].'_comment'))) {
                if($feed['type_id'] == 'user_status') {
                    db()->delete(Phpfox::getT('user_status'), 'status_id = '. (int)$feed['item_id']);
                }
                elseif ($feed['type_id'] == 'feed_comment') {
                    db()->delete(Phpfox::getT('feed_comment'), 'feed_comment_id = '. (int)$feed['item_id']);
                }
                else {
                    $table = $aCallback['table_prefix'] .'feed_comment';
                    db()->delete(Phpfox::getT($table), 'feed_comment_id = '. (int)$feed['item_id']);
                }
                $feedTable = (!empty($aCallback['table_prefix']) ? $aCallback['table_prefix'] : '') .'feed';
                $updateFeedTable = [
                    'type_id' => 'link', 'item_id' => $iId
                ];
                if(!empty($hasPrivacy['privacy'])) {
                    $updateFeedTable['privacy'] = $aVals['privacy'];
                }
                if(!empty($hasPrivacy['privacy_comment'])) {
                    $updateFeedTable['privacy_comment'] = $aVals['privacy_comment'];
                }
                db()->update(Phpfox::getT($feedTable), $updateFeedTable, 'feed_id = '. (int)$aVals['feed_id']);
                //Update feed in phpfox_feed
                if(in_array($aCallback['module'], ['pages', 'groups'])) {
                    db()->update(Phpfox::getT('feed'), $updateFeedTable, 'type_id = "'. $feed['type_id'] .'" AND item_id = '. (int)$feed['item_id']);
                }
            }
        }
        else {
            $iId = $feed['item_id'];
            $updateFeedTable = [];
            $feedTable = (!empty($aCallback['table_prefix']) ? $aCallback['table_prefix'] : '') .'feed';
            if(!empty($hasPrivacy['privacy'])) {
                $updateFeedTable['privacy'] = $aVals['privacy'];
            }
            if(!empty($hasPrivacy['privacy_comment'])) {
                $updateFeedTable['privacy_comment'] = $aVals['privacy_comment'];
            }
            if(!empty($updateFeedTable)) {
                db()->update(Phpfox::getT($feedTable), $updateFeedTable, 'feed_id = '. (int)$feed['feed_id']);
            }
            db()->update($this->_sTable, $aInsert,'link_id = '. $iId);
        }

        if (Phpfox::isModule('tag') && Phpfox::getParam('tag.enable_hashtag_support')) {
            Phpfox::getService('tag.process')->add('link', $iId, Phpfox::getUserId(), $aVals['status_info'], true);
        }

        if($isUpdate) {
            $count = db()->select('COUNT(*)')
                ->from(Phpfox::getT('link_embed'))
                ->where('link_id = '. $iId)
                ->execute('getSlaveField');
            $embedCode = !empty($aVals['link']['embed_code']) ? $this->preParse()->prepare($aVals['link']['embed_code']) : '';
            if($count) {
                db()->update(Phpfox::getT('link_embed'), ['embed_code' => $embedCode], 'link_id = '. (int)$iId);
            }
            else {
                if(!empty($embedCode)) {
                    db()->insert(Phpfox::getT('link_embed'), array(
                            'link_id' => $iId,
                            'embed_code' => $this->preParse()->prepare($aVals['link']['embed_code'])
                        )
                    );
                }
            }
        }
        else
        {
            if (!empty($aVals['link']['embed_code'])) {
                $this->database()->insert(Phpfox::getT('link_embed'), array(
                        'link_id' => $iId,
                        'embed_code' => $this->preParse()->prepare($aVals['link']['embed_code'])
                    )
                );
            }
        }

        if (!$isUpdate && $aCallback === null && isset($aVals['parent_user_id']) && $aVals['parent_user_id'] > 0 && $aVals['parent_user_id'] != Phpfox::getUserId()) {
            $aUser = $this->database()->select('user_name')
                ->from(Phpfox::getT('user'))
                ->where('user_id = ' . (int)$aVals['parent_user_id'])
                ->execute('getSlaveRow');

            $sLink = Phpfox_Url::instance()->makeUrl($aUser['user_name'], array('link-id' => $iId));

            Phpfox::getLib('mail')->to($aVals['parent_user_id'])
                ->subject(array('link.full_name_posted_a_link_on_your_wall', array('full_name' => Phpfox::getUserBy('full_name'))))
                ->message(array('link.full_name_posted_a_link_on_your_wall_message', array('full_name' => Phpfox::getUserBy('full_name'), 'link' => $sLink)))
                ->notification('comment.add_new_comment')
                ->send();

            if (Phpfox::isModule('notification')) {
                Phpfox::getService('notification.process')->add('feed_comment_link', $iId, $aVals['parent_user_id']);
            }
        }

        if (Phpfox::isModule('privacy') && $aVals['privacy'] == '4') {
            $function = $isUpdate ? 'update' : 'add';
            Phpfox::getService('privacy.process')->{$function}('link', $iId,
                (isset($aVals['privacy_list']) ? $aVals['privacy_list'] : array()));
        }

        $aMentions = Phpfox::getService('user.process')->getIdFromMentions($aVals['status_info'], true);
        $aTagged = [];
        if (!empty($aVals['tagged_friends'])) {
            $aTagged = explode(',', $aVals['tagged_friends']);
        }
        $allTagged = array_merge($aTagged, $aMentions);

        // check permission 'can_i_be_tagged' = 4 (no one)
        if (array_filter($allTagged)) {
            $sUsers = implode(',', $allTagged);
            $aPerms = $this->database()->select('user_id')->from(Phpfox::getT('user_privacy'))->where('user_id in (' . $sUsers . ' ) AND user_privacy = \'user.can_i_be_tagged\' AND user_value = 4')->execute('getSlaveRows');
            $noTagUserIds = array_column($aPerms, 'user_id');
            $aMentions = array_diff($aMentions, $noTagUserIds); // remove noTagUserIds
            $aTagged = array_diff($aTagged, $noTagUserIds); // remove noTagUserIds
        }

        $needAddTagged = $aTagged;
        $taggedUsers = $needInsert ? $this->cache()->get('tagged_users_'. $feed['type_id'] .'_'. $feed['item_id']) : $this->cache()->get('tagged_users_link_'. $iId);
        $taggedUsers = !empty($taggedUsers) ? array_column($taggedUsers,'user_id') : [];
        // tagged friends
        if (count($aTagged)) {
            $needNotify = array_combine($aTagged, $aTagged);
            if($isUpdate) {
                if(!empty($taggedUsers)) {
                    foreach($aTagged as $userId) {
                        if(in_array($userId, $taggedUsers)) {
                            unset($needNotify[$userId]);
                        }
                    }
                    if(!$needInsert) {
                        $removedUsers = array_diff($taggedUsers, $aTagged);
                        if(!empty($removedUsers)) {
                            db()->delete(Phpfox::getT('feed_tag_data'),'item_id = '. (int)$iId .' AND type_id = "link" AND user_id IN ('. implode(',', $removedUsers) .')');
                        }
                        $needAddTagged = array_diff($aTagged, $taggedUsers);
                    }
                    else {
                        db()->delete(Phpfox::getT('feed_tag_data'), 'item_id = '. (int)$feed['item_id'] . ' AND type_id = "'. $feed['type_id'] .'"');
                    }
                }
            }
            Phpfox::getService('feed.process')->addTaggedUsers($iId, $needAddTagged, 'link');
            foreach ($needNotify as $iFriendId) {
                $this->_notifyTaggedUser($iId, $iFriendId);
            }
        }
        else {
            Phpfox::getService('feed.process')->updateTaggedUsers($iId, 'link', $aTagged);
        }

        // notify tagged users
        if (count($aMentions)) {
            foreach ($aMentions as $iUserId) {
                if (!in_array($iUserId, $needAddTagged) && !in_array($iUserId, $taggedUsers)) {
                    $this->_notifyTaggedUser($iId, $iUserId);
                }
            }
        }

        $this->_iLinkId = $iId;

        return ($bIsCustom ? $iId : (!$isUpdate ? Phpfox::getService('feed.process')->callback($aCallback)->add('link', $iId, $aVals['privacy'], $aVals['privacy_comment'], (isset($aVals['parent_user_id']) ? (int)$aVals['parent_user_id'] : 0)): $aVals['feed_id']));
    }

    private function _notifyTaggedUser($iId, $iUserId)
    {
        if (Phpfox::isModule('notification')) {
            Phpfox::getService('notification.process')->add('feed_tagged_link', $iId, $iUserId);
        }
        // send email
        Phpfox::getLib('mail')->to($iUserId)
            ->subject(['full_name_tagged_you_in_a_link', ['full_name' => Phpfox::getUserBy('full_name')]])
            ->message(['full_name_tagged_you_in_a_link_you_can_view_here', [
                'full_name' => Phpfox::getUserBy('full_name'),
                'link' => Phpfox_Url::instance()->makeUrl(Phpfox::getUserBy('user_name'), array('link-id' => $iId)),
            ]])
            ->send();
    }

    public function getInsertId()
    {
        return (int)$this->_iLinkId;
    }

    public function delete($iId)
    {
        $aLink = $this->database()->select('l.*, a.*')
            ->from(Phpfox::getT('link'), 'l')
            ->join(Phpfox::getT('attachment'), 'a', 'a.link_id = l.link_id')
            ->where('l.link_id = ' . (int)$iId)
            ->execute('getSlaveRow');

        if (!isset($aLink['link_id'])) {
            return false;
        }

        if ((Phpfox::getUserParam('attachment.delete_own_attachment') && $aLink['user_id'] == Phpfox::getUserId()) || Phpfox::getUserParam('attachment.delete_user_attachment')) {
            $this->database()->delete(Phpfox::getT('link'), 'link_id = ' . (int)$aLink['link_id']);
            Phpfox::getService('attachment.process')->updateItemCount($aLink['category_id'], $aLink['attachment_id'], '-');

            if (!empty($aLink['attachment_id'])) {
                $this->database()->delete(Phpfox::getT('attachment'), 'attachment_id = ' . (int)$aLink['attachment_id']);
            }
        }

        return false;
    }

    /**
     * If a call is made to an unknown method attempt to connect
     * it to a specific plug-in with the same name thus allowing
     * plug-in developers the ability to extend classes.
     *
     * @param string $sMethod is the name of the method
     * @param array $aArguments is the array of arguments of being passed
     */
    public function __call($sMethod, $aArguments)
    {
        /**
         * Check if such a plug-in exists and if it does call it.
         */
        if ($sPlugin = Phpfox_Plugin::get('link.service_process__call')) {
            eval($sPlugin);
            return null;
        }

        /**
         * No method or plug-in found we must throw a error.
         */
        Phpfox_Error::trigger('Call to undefined method ' . __CLASS__ . '::' . $sMethod . '()', E_USER_ERROR);
    }
}